local function show_fullscreen_formspec(player_name)
    local formspec = [[
        formspec_version[4]
        size[16,9]
        label[1,1;Congratulations! You defeated the Beast!]
        image[4.5,2;9,4.5;image_won.png]
        button_exit[6.5,6;3,1;exit;Exit Game]
    ]]

    -- Show the formspec
    minetest.show_formspec(player_name, "beast:end_game", formspec)
end

--beast--
mobs:register_mob("beast:beast", {
type = "monster",
	hp_max = 200,
	stepheight = 1,
	pathfinding = true,
	visual_size = {x=1, y=1},
	collisionbox =  {-0.5, -0.5, -0.5, 0.5, 0.5, 0.5},
	visual = "mesh",
	mesh = "beast.b3d",
	textures = {
		{"beast.png"},
	},
	view_range = 10000,
	walk_velocity = 3,
	run_velocity = 4,
	damage = 3,
	drops = {},
	armor = 200,
	drawtype = "front",
	water_damage = 0,
	lava_damage = 1,
	light_damage = 0,
	jump = false,
	suffocation = 0,
	reach = 1,
	fear_height = 0,
	walk_chance = 100,
	stand_chance = 50,
	attack_chance = 50,
	blood_amount = 0,
	randomly_turn = true,
	passive = false,
	group_attack = false,
	attack_players = true,
	attack_type = "dogfight",
	on_death = function(self, hitter)
        if hitter:is_player() then
	-- Default health logic
	self.health = (self.health or 10) - 1
	if self.health <= 0 then
	self.object:remove() -- Remove the beast

	show_fullscreen_formspec(hitter:get_player_name())

	minetest.register_on_player_receive_fields(function(player, formname, fields)
	if formname == "beast:end_game" and fields.exit then
	minetest.request_shutdown("Thanks for playing!", true)
				end
			end)
		end
	end
end,
	collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
	selectionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
	animation = {
		stand_start = 0,
		stand_end = 225,
		stand_speed = 15,
		walk_start = 169,
		walk_end = 186,
		walk_speed = 15,
		run_start = 200,
		run_end = 220,
		run_speed = 20,
		punch_start = 189,
		punch_end = 200,
		punch2_start = 200,
		punch2_end = 220,
		punch_speed = 21,
		die_start = 160,
		die_end = 165,
		die_speed = 15,
	},
})

local MP = minetest.get_modpath(minetest.get_current_modname()) .. "/"
local input = io.open(MP .. "spawn.lua", "r")

if input then
	input:close()
	input = nil
	dofile(MP .. "spawn.lua")
else

	mobs:spawn({
		name = "beast:beast",
		nodes = {"misc:skull"},
		neighbors = "air",
		chance = 7000,
		active_object_count = 2,
		min_height = -31000,
		max_height = 31000,
	})

end

mobs:register_spawn("beast:beast", {"misc:skull"}, 20, -1, 14000, 1, -64)

mobs:register_egg("beast:beast", "beast", "beast.png", 3)

--[[
minetest.register_node("beast:spawner_node", {
    description = "Beast Spawner",
    tiles = { "break_me.png" },
    is_ground_content = false,
    groups = {dig_immediate = 3,crumbly = 1 },

    -- Function when the node is broken
    on_dig = function(pos, node, digger)
        -- Spawn the beast entity at the position of the node
        minetest.add_entity(pos, "beast:beast")

        -- Send a chat message to all players
        minetest.chat_send_all("The beast has been unleashed!")

        -- Remove the node after being broken
        minetest.remove_node(pos)
    end,
})
--]]--


-- Define the spawner node
minetest.register_node("beast:spawner_node", {
    description = "Beast Proximity Spawner",
    tiles = { "transparent.png" },
    drawtype = "airlike",
    is_ground_content = false,
    groups = {dig_immediate = 3,crumbly = 1 ,cracky = 1 },

    -- Node metadata to track spawning status
    on_construct = function(pos)
        local meta = minetest.get_meta(pos)
        meta:set_int("has_spawned", 0) -- Set default: no entity spawned yet
    end,
})

-- Function to check proximity and spawn the beast
local function check_proximity_and_spawn(pos, radius)
    -- Check for players near the position
    local objects_nearby = minetest.get_objects_inside_radius(pos, radius)

    for _, obj in ipairs(objects_nearby) do
        if obj:is_player() then
            local meta = minetest.get_meta(pos)
            local has_spawned = meta:get_int("has_spawned")

            -- If the beast hasn't spawned yet, spawn it
            if has_spawned == 0 then
                minetest.add_entity(pos, "beast:beast")
                minetest.chat_send_all("The beast has been unleashed !")
                meta:set_int("has_spawned", 1)
                break
            end
        end
    end
end

minetest.register_abm({
    nodenames = { "beast:spawner_node" },
    interval = 1.0,
    chance = 1,
    action = function(pos, node)
        local radius = 5
        check_proximity_and_spawn(pos, radius)
    end,
})

